*****************************************************
// RD interaction spec
*****************************************************
global texfile "$output\table_firststagepooled.tex"
global cluster age // this is only relevant for the boottest code

global controls 
set seed 2830
* Create mock column
qui reg phicmem 
  est stor fmock

* Estimate first-stage regression
foreach f in 0 1 2 /*3*/  { 
  macro drop flist`f'_`ggg'`lll'
     
	
	if (`f' == 0) {
		local fX
	 }
	else {
		local fX `fX' X`f'
	 }
    global flist`f'
	 
	
	use "$data\apisfile", clear
	foreach b in  2 5 10 { 
		if `b'<5 {
		global webb "weight(webb)" // Webb weights are recommended when #clusters < 10 or 12 	
		}
			
			if `f' < `b' {
				global name apis`f'_b`b'
				eststo $name: reg phicmem 1.yr#1.D 1.D i.year c.(`fX') i.D#c.(`fX') $controls if inrange(X1, -`b', `b'-1) , cluster(hhid)				
				reg phicmem 1.yr#1.D 1.D i.year c.(`fX') i.D#c.(`fX') $controls if inrange(X1, -`b', `b'-1) , cluster($cluster)				
					qui estadd ysumm
					*qui est store apis`f'_b`b'
					
					 do "$code\boottest_output"

				global flist`f' ${flist`f'} apis`f'_b`b'
			 }
			else {
				global flist`f' ${flist`f'} fmock
			 }
			 
		
		global webb
		 
	 }
	 
	 
	 use "$data\ndhsfile", clear
 	foreach b in  2 5 10 { 
		if `b'<=5 {
		global webb "weight(webb)"
		}	
			
			if `f' < `b' {
				global name ndhs`f'_b`b'
				eststo $name: reg phicmem 1.yr#1.D 1.D i.year c.(`fX') i.D#c.(`fX') $controls if inrange(X1, -`b', `b'-1) , cluster(hhid)
				reg phicmem 1.yr#1.D 1.D i.year c.(`fX') i.D#c.(`fX') $controls if inrange(X1, -`b', `b'-1) , cluster($cluster)
					qui estadd ysumm
					*qui est store ndhs`f'_b`b'
					
					do "$code\boottest_output"
					
				global flist`f' ${flist`f'} ndhs`f'_b`b'
			 }
			else {
				global flist`f' ${flist`f'} fmock
			 }
			 
		global webb
		 
	 }
}

* Capture column-wise scalars
cap matrix drop stats
foreach file in apis ndhs {
	foreach b in  2 5 10 { 
		local aic_min = .
		
			foreach f in 0 1 2 /*3*/ { 
				
				
				if `f' < `b' {
					qui {
						est restore `file'`f'_b`b'
						estat ic
						mat M = r(S)
					
					}	
					if M[1,5] < `aic_min' {
						local aic_min = M[1,5] 
						mat statsX = `f' \ `=e(N)'
					}
				 }
				
				
			 }
			 
		mat stats = nullmat(stats), statsX 
		
		 
	 }
}
mat rowname stats = "Optimal Order" "\$ N\$"
 
* Print table in latex 
local latex_opt_top  ///
	prehead( ///
		"\begin{tabular}{l*{@M}{rr}}" ///
		"\hline" ///
		"\hline" ///
		) ///
	posthead( ///
		" & \multicolumn{3}{c}{APIS} & \multicolumn{3}{c}{DHS} \\" ///
		"Bandwidth & \multicolumn{1}{c}{2} & \multicolumn{1}{c}{5} & \multicolumn{1}{c}{10} & \multicolumn{1}{c}{2} & \multicolumn{1}{c}{5} & \multicolumn{1}{c}{10} \\" ///
		"\hline" ///
		"\hline" ///
		"Polynomial Order & \multicolumn{@M}{c}{} \\" ///
		)
local latex_opt_end  ///
	prefoot( ///
		"\hline" ///
		) ///
	postfoot( ///
		"\hline" ///
		"\end{tabular}" ///
		)
local labopt_est  keep(1.yr#1.D ) cells(b(fmt(a2)) se(star fmt(a2) par) boot_pval( fmt(2) par([ ]))) collabels(none) varw(17) style(tex) 
local labopt_est0 mlabel(none) `latex_opt_top' replace 
local labopt_estX mlabel(none) append
local labopt_fin  mlabel(none) collabels(none) modelw(15) varw(17) style(tex) `latex_opt_end' append

estout $flist0 using "$texfile", `labopt_est' `labopt_est0' varlabel(1.yr#1.D Zero) starlevels(* 0.1 ** 0.05 *** 0.01)
estout $flist1 using "$texfile", `labopt_est' `labopt_estX' varlabel(1.yr#1.D One) starlevels(* 0.1 ** 0.05 *** 0.01)
estout $flist2 using "$texfile", `labopt_est' `labopt_estX' varlabel(1.yr#1.D Two) starlevels(* 0.1 ** 0.05 *** 0.01)
estout matrix(stats, fmt(%8.0f)) using "$texfile", `labopt_fin' 
